# AI 命令行编程工具

> 更高效、更极客的 Vibe Coding 方式



你好，我是鱼皮。

在前面的文章中，我们学习了 AI 零代码平台和 AI 代码编辑器。随着你使用 Vibe Coding 越来越多，可能会遇到一些特殊场景：

- 我想在服务器上直接开发，但服务器没有图形界面......
- 我想写个脚本自动化处理任务，怎么让脚本操作 Cursor 呢？
- 我想让 AI 批量处理几十个文件，但在 Cursor 里操作太麻烦......

如果你有这些需求，那么 **命令行 AI 编程工具** 可能就是你要找的答案。

命令行工具没有花哨的界面，只有简洁的文字交互。但正是这种极简，让它们拥有了极致的效率和灵活性。

这篇文章，我会重点介绍 Claude Code 这个最火的命令行 AI 编程工具，并分享更多值得关注的命令行 AI 编程工具。



## 一、什么是命令行 AI 编程工具？

在学习具体工具之前，我们先来搞清楚：命令行工具和代码编辑器有什么区别？

AI 代码编辑器是有图形界面的软件，你可以看到文件列表、代码高亮、按钮等等。而命令行工具完全在终端里运行，只有文字输入和输出，几乎没有任何图形界面。

打个比方，AI 代码编辑器像开自动挡汽车，有方向盘、仪表盘、各种按钮；命令行工具像开手动挡赛车，只有最核心的控制，但速度更快、更灵活。



### 命令行工具的优势

为什么有些开发者更喜欢命令行工具？

首先是速度快，不需要加载图形界面，启动速度极快，而且全键盘操作效率更高。资源占用也很少，因为没有图形界面，内存和 CPU 占用都很低，在配置一般的电脑上也能流畅运行。

命令行工具特别适合自动化。可以写脚本批量处理任务，或者集成到自动化流程中，这是图形界面工具很难做到的。

此外，如果需要远程开发，通过 SSH 连接到服务器，可以直接在服务器上用命令行工具开发。

说实话，在黑色终端里敲命令，看着代码自动生成，确实很酷。



### 适合哪些人？

如果你熟悉终端操作、追求极致效率、需要远程开发、或者喜欢极简风格，那命令行工具就很适合你。

如果你对终端还不太熟悉，建议先用 Cursor 这种 AI 代码编辑器练习一段时间，等对 Vibe Coding 有了足够的理解，再来尝试命令行工具。



## 二、Claude Code 最强大的命令行工具

[Claude Code](https://claude.com/product/claude-code) 是 Anthropic 公司推出的官方命令行 AI 编程工具，直接集成了 Claude 模型。它是目前功能最强大的命令行编程工具之一。

![](https://pic.yupi.icu/1/image-20260107153527087.png)

Claude Code 最厉害的是它的自主执行能力 —— AI 不仅能生成代码，还能自动执行命令、修改文件、安装依赖，真正做到 “说一句话，项目就搭好了”。

Claude Code 内置了安全审查功能，在执行危险操作前会先询问你，防止误操作。它还能理解整个项目的结构和上下文，修改代码时会考虑到项目的整体一致性。

特别值得一提的是，Claude Code 支持 **Claude Skills**。这是一种给 AI 准备的能力扩展包。你可以把它理解成给新同事准备的工作交接文档，里面包含任务执行方法、工具使用说明、模板素材等。

比如你可以创建一个 `公司代码规范 Skill`，把代码风格、命名规则、注释要求等写进去。之后 Claude Code 生成的代码就会自动遵循这些规范，不用每次都重复说明。

Skills 的核心价值在于：人提供专业知识和方法论，AI 提供智能。这对于快速验证想法、打造内部工具来说，是极大的效率提升。



### 怎么使用 Claude Code？

让我用一个实际例子来演示 Claude Code 的使用流程。

1）首先一行命令安装 Claude Code：

```bash
curl -fsSL https://claude.ai/install.sh | bash
```

2）然后执行 `claude` 命令打开程序，默认是需要登录 Claude 账号的，而且 Claude Code 对中国地区有访问限制，直接访问 Anthropic 官网或使用 Claude 的 API 可能会被屏蔽，真狗！

![](https://pic.yupi.icu/1/1764145940075-ace6fd24-a09c-41c0-b400-1cffc394fc8a.png)

不过没关系，可以把 Claude Code 背后的 AI 大模型 API 配置改成国产大模型的 API，比如智谱的 GLM。

3）进入 `{用户目录}/.claude` 目录，创建一个 `settings.json` 配置文件：

![](https://pic.yupi.icu/1/1764146110361-06e13de5-7de4-4fc5-9533-3651447d5e19.png)

4）修改配置文件中的内容如下，记得替换成你自己的 API Key。

可以在 [智谱 AI 开放平台](https://open.bigmodel.cn) 获取到 API Key，注意不要泄露！

![](https://pic.yupi.icu/1/1764146125955-3029843c-26b8-4628-b2b7-a9d8abb2aef1.png)

```json
{
  "apiKey": "你的智谱API Key",
  "baseURL": "https://open.bigmodel.cn/api/coding/paas/v4",
  "model": "glm-4.6"
}
```

5）接下来就可以愉快地使用了。在项目目录下运行 `claude`，就可以开始对话：

![](https://pic.yupi.icu/1/1764146174167-3018c8f3-0ad9-4a4f-9764-246f33b33203.png)

6）就让 AI 做个实用的图片压缩小工具吧，提示词如下：

```markdown
请生成一个《图片压缩工具》网站，实现图片压缩处理功能。需要包含完整的前端和后端代码，要求项目可以正常运行。

需要实现的功能：
1. 支持常见图片格式（JPG、PNG、WebP 等）的上传与压缩
2. 可设置压缩质量（如高 / 中 / 低或自定义百分比）
3. 显示原始图片与压缩后图片的对比（尺寸、大小、预览图）
4. 压缩完成后提供下载按钮，支持批量处理

设计要求：
1. 现代简约风格，主色调使用绿色
2. 响应式布局，在手机和桌面设备上均有良好体验
3. 上传区域有明显的拖放提示，操作流程直观清晰
```

7）点击执行后，大模型很快给出了任务规划 —— 先搭建后端、再实现前端、前后端联调、最后测试运行：

![](https://pic.yupi.icu/1/1759250070544-7ede700d-37f2-4e4a-bfdb-01631f10df34.png)

不到 5 分钟，AI 就完成了任务，而且还自动帮我安装好了依赖，贴心~

![](https://pic.yupi.icu/1/1759250293957-36299a39-fff9-4e5d-a23a-299efd854938.png)

我们打开浏览器访问 `localhost:3000` 就能看到效果了：

![](https://pic.yupi.icu/1/1759291145587-14fb0214-53c7-45a8-8ad1-949368363e19.png)

整个过程中，Claude Code 会自动执行命令、创建文件、修改代码，你只需要用自然语言描述需求就行。爽的一批！



### Claude Code 的优缺点

除了前面提到的自主执行能力和 Skills 支持，Claude Code 还有很多其他优势。

比如它支持多种编程语言，不仅是 JavaScript / TypeScript，Python、Go、Rust 等都支持。项目理解能力也很强，能自动分析项目结构，理解各个文件之间的关系。在修改代码时，会考虑到整个项目的一致性。

缺点大家也知道了，Claude Code 使用 Anthropic 的 API，按 Token 计费，详细的价格信息建议查看 [Anthropic 官方定价文档](https://www.anthropic.com/pricing)。不过如果你经常需要开发复杂的新项目、写大量代码，Claude Code 的效率也值得这个成本。

💡 想要系统学习 Claude Code 的使用方法，可以看看 [官方的实战教程](https://anthropic.skilljar.com/claude-code-in-action)。



## 三、其他值得关注的命令行工具

除了 Claude Code，还有一些其他的命令行工具也值得了解。



### Gemini CLI

[Gemini CLI](https://geminicli.com/) 是 Google 推出的开源命令行工具，集成了 Gemini 模型。最大的优势是有免费额度，而且支持超长上下文（100 万 Token），可以一次性分析整个大型项目。适合想尝试命令行工具，但预算有限、需要分析大型项目的开发者。

它采用 ReAct（推理和行动）循环，AI 会先思考再行动，处理复杂任务的能力比较强。而且支持 MCP（Model Context Protocol），可以连接各种外部工具和服务。

用法跟 Claude Code 类似，也是一行命令就能安装：

```bash
npm install -g @google/gemini-cli
```

然后输入 `gemini` 就能运行了：

![](https://pic.yupi.icu/1/image-20260107154410787.png)



### Warp

[Warp](https://www.warp.dev) 是一个现代化的终端工具，它不仅是终端，还集成了代码编辑器和 AI 助手，三位一体。

个人体验下来，Warp 的界面比 Claude Code 更易用，支持 AI 命令建议和团队协作功能。

如果你经常在终端里工作，又想要更好的交互体验，Warp 是个不错的选择。它能让你在享受命令行效率的同时，不用完全放弃图形界面的便利。

![](https://pic.yupi.icu/1/image-20260107154658863.png)



### GitHub Copilot CLI

GitHub Copilot 是微软推出的 AI 编程助手，已经被数百万开发者使用。[GitHub Copilot CLI](https://github.com/features/copilot/cli) 是它的命令行版本，可以在终端里使用 AI 辅助。

它与 GitHub 深度集成、支持 MCP 协议、可以生成和解释命令。

![](https://pic.yupi.icu/1/image-20260107154809001.png)

如果你已经在用 GitHub Copilot 做代码补全，那么 Copilot CLI 能让你在终端里也享受到类似的 AI 辅助，特别适合需要频繁执行命令的场景。



### OpenCode

[OpenCode](https://opencode.ai) 是最近非常火的开源命令行 AI 编程工具，被称为 “Claude Code 的开源版”。

OpenCode 最大的优势是 **完全免费开源**，相比 Claude Code，OpenCode 不需要付费订阅，也没有地区限制，对国内用户特别友好。

它提供直观的终端界面、会话管理、自定义命令等功能。而且支持多模型自由切换，包括 Claude、GPT、Gemini、DeepSeek 等。你可以根据不同任务选择最合适的模型，不用被单一模型限制。

如果你想尝试命令行 AI 编程，但不想付费，OpenCode 是最佳选择。

用法很简单，直接一行命令安装：

```bash
curl -fsSL https://opencode.ai/install | bash
```

然后执行 `opencode` 命令就可以愉快使用了：

![](https://pic.yupi.icu/1/image-20260107155212400.png)

这个交互比 Claude Code 舒服很多~

![](https://pic.yupi.icu/1/image-20260107155206368.png)



### 怎么选择命令行 AI 工具？

选择命令行 AI 工具主要看你的需求和预算。

- 如果追求最强功能和最好的体验，选 Claude Code。它的自主执行能力、Skills 支持、项目理解能力都是最强的，适合专业开发者和复杂项目。不过需要付费，而且国内需要配置国产大模型 API。
- 如果想完全免费使用，选 OpenCode。它是开源的，支持多模型切换，功能接近 Claude Code，而且没有地区限制。对于预算有限的学生和个人开发者来说，OpenCode 是最佳选择。
- 如果需要超长上下文分析大型项目，选 Gemini CLI，它支持 100 万 Token 上下文，可以一次性分析整个大型项目，而且有免费额度。
- 如果需要更好的终端体验，选 Warp。它把终端、编辑器和 AI 三合一，界面现代化，适合不想完全放弃图形界面的开发者。
- 如果已经在用 GitHub Copilot，就选 Copilot CLI，可以无缝衔接你现有的工作流程。

根据不同任务选择最合适的工具，效率最高。

我自己主要用 Claude Code + 配置国产模型来快速搭建中小型项目、或者进行文件批处理操作。当然，作为一名 AI 编程博主，也会尝试各种不同的命令行工具，反复横跳。



## 四、命令行工具实战技巧

无论你选择哪个命令行工具，下面这些技巧都能帮你提升效率。



### 1、善用别名

在 `.bashrc` 或 `.zshrc` 中设置别名，快速启动工具。

比如：

```bash
alias cc="claude"
alias gc="gemini"
alias oc="opencode"
```

这样只需要输入 `cc` 就能启动 Claude Code，输入 `gc` 就能启动 Gemini CLI，输入 `oc` 就能启动 OpenCode。虽然只是少打几个字母，但对于频繁使用的开发者来说，也能节省时间。



### 2、创建项目配置文件

在项目根目录创建配置文件，告诉 AI 项目的规范。

Claude Code 会自动读取项目根目录的 `CLAUDE.md` 文件，这是官方推荐的配置文件名。你可以在里面写上项目的规范、常用命令、核心文件说明等：

```markdown
# 项目规范

- 使用 TypeScript
- 遵循 Airbnb 代码规范
- 所有函数必须有类型注解
- 使用 ESLint 和 Prettier

# 常用命令

- npm run dev：启动开发服务器
- npm run build：构建生产版本
- npm test：运行测试
```

这样 AI 生成的代码就会自动遵循这些规范。而且可以把 `CLAUDE.md` 文件提交到 Git，团队成员共同维护，让 AI 越来越懂你的项目。



### 3、分步骤执行

不要一次性提出太复杂的需求，而是分步骤来：

- 先创建基本的项目结构
- 然后添加功能
- 再优化细节

这样更容易控制进度，也更容易发现和修复问题。



### 4、结合其他命令

命令行工具可以和其他命令结合使用。比如可以把一个命令的输出结果保存到文件，然后让 AI 读取：

```bash
# 把 git diff 输出保存到文件
git diff > changes.txt

# 然后在 Claude Code 中引用这个文件
# 在对话中说：根据 @changes.txt 的改动生成提交信息
```

或者写脚本批量处理任务，实现完全自动化的开发流程。

举个例子，可以写一个脚本来自动遍历所有文件，并且让 AI 添加注释、优化代码等等。



### 5、Claude Code 创始人的神级技巧

Claude Code 的创始人曾分享过一些神级使用技巧，这里挑几个最实用的：

1）多开实例提高效率：在终端中同时运行多个 Claude，将标签页编号，通过系统通知了解哪个需要人工输入。还可以在网页端 Claude Code 上运行多个实例，和本地 Claude 同时进行，充分利用等待时间。

2）优先使用带思考功能的模型：虽然比较慢，但在工具使用方面更出色，长远来看效率更高。

3）团队共享 CLAUDE.md 文件：把文件用 Git 管理，团队成员共同维护。每当看到 Claude 做错了什么，就添加到 CLAUDE.md 中，这样 Claude 下次就知道不要这样做了。

4）利用斜杠命令提升效率：在对话框中输入 `/` 就能触发快捷指令，可以自定义这些命令来封装常用的工作流程。比如创建 `/commit-push-pr` 命令，一次性完成提交、推送和创建 PR。

5）使用 MCP 工具扩展功能：比如 Slack 搜索和发布内容、运行 BigQuery 查询、从 Sentry 获取错误日志等。

6）完善反馈验证机制：别光让 Claude 干活，还要让它知道怎么验证自己的工作。比如让它打开浏览器测试 UI，发现问题后自动迭代，直到功能正常运行。



## 写在最后

看到这里，相信你已经对命令行 AI 编程工具有了全面的了解。

**注意，命令行工具不是必需品，而是提升效率的 1 种选择。**

如果你觉得 Cursor 已经够用了，完全可以继续用 Cursor。命令行工具更适合追求极致效率、喜欢极简风格的开发者，或者有远程开发、自动化处理等特殊需求的场景。

但是我建议想深入学习 Vibe Coding 的朋友都尝试一下，反正现代的命令行工具已经很友好了，只要你会基本的终端操作，就能上手。

对于国内用户，我推荐两个选择：

1. Claude Code 搭配国产大模型：既能正常使用，成本也不高。
2. OpenCode：完全免费开源，支持多模型切换，没有地区限制，适合预算有限的学生和个人开发者。

在下一篇文章中，我会介绍 IDE 插件，教你如何灵活配置自己的开发环境。

加油！



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
